f = @SgnQ; %%% network test (output must be pv, raw, st )
n = 50;  %%% number of vertices 
M = 2000; %%% number of trials

close all

GC3_vec_ER = zeros(M,1);
GC3_vec_het = zeros(M, 1);
Gc3_vec_het_ER = zeros(M, 1);

%%%%%% pareto

a = 4;
b = 0.375; 

for i = 1:M
    theta = sqrt(0.1)*gprnd(1/a, b/a, b, n, 1);
    A = binornd(ones(n,n), theta*theta');
    A = A - tril(A) ;
    A = A + A';

    [~,~,Gc3_vec_het_ER(i)] = f(A);
end 

figure  
fprintf('Empirical mean for pareto: %d\n', mean(Gc3_vec_het_ER) )
fprintf('Empirical stdev for pareto: %d\n', std(Gc3_vec_het_ER) )
histogram(Gc3_vec_het_ER, "Normalization","pdf")
title('Histogram for pareto')

hold on 
x = [-3:.1:3];
y = normpdf(x,0,1);
plot(x,y,'k')

%%%% Erdos-Renyi  
% for i = 1:M
%     A = binornd(1,0.1,n,n);
%     A = A - tril(A) ;
%     A = A + A';
% 
%     [~,~,GC3_vec_ER(i)] = f(A); 
% end 
% 
% fprintf('Empirical mean for Erdos-Renyi: %d\n', mean(GC3_vec_ER) )
% fprintf('Empirical stdev for Erdos-Renyi: %d\n', std(GC3_vec_ER) )
% histogram(GC3_vec_ER,"Normalization","pdf")
% title('Histogram for Erdos-Renyi')
% 
% hold on 
% x = [-3:.1:3];
% y = normpdf(x,0,1);
% plot(x,y,'k')

%%%%%%% K = 1 w/uniform random theta
% figure 
% 
% for i = 1:M
%     alpha = sqrt(0.2);
%     theta = alpha*rand(n,1);
%     A = binornd(ones(n,n), theta*theta');
%     A = A - tril(A) ;
%     A = A + A';
% 
%     [~,~,GC3_vec_het(i)] = f(A);
% end 
% 
% fprintf('Empirical mean for uniform random heterogeneity, K = 1: %d\n', mean(GC3_vec_het) )
% fprintf('Empirical stdev for uniform random heterogeneity, K = 1: %d\n', std(GC3_vec_het) )
% histogram(GC3_vec_het,"Normalization","pdf")
% title('Histogram for uniform random heterogeneity, K = 1')
% 
% hold on 
% x = [-3:.1:3];
% y = normpdf(x,0,1);
% plot(x,y,'k')
% 
%%%%%%%% generate K = 1 DCBM w/structured + uniform random theta
% 
% for i = 1:M
%     theta = sqrt(0.05)*ones(n,1);
%     theta(1:(round(n/2))) = 0.1*rand(round(n/2),1);
%     A = binornd(ones(n,n), theta*theta');
%     A = A - tril(A) ;
%     A = A + A';
% 
%     [~,~,Gc3_vec_het_ER(i)] = f(A);
% end 
% 
% figure  
% fprintf('Empirical mean for model 3: %d\n', mean(Gc3_vec_het_ER) )
% fprintf('Empirical stdev for model 3: %d\n', std(Gc3_vec_het_ER) )
% histogram(Gc3_vec_het_ER, "Normalization","pdf")
% title('Histogram for model 3')
% 
% hold on 
% x = [-3:.1:3];
% y = normpdf(x,0,1);
% plot(x,y,'k')


